local playMode = GAMESTATE:GetPlayMode()
if playMode ~= 'PlayMode_Regular' and playMode ~= 'PlayMode_Rave' and playMode ~= 'PlayMode_Battle' then
	curStage = playMode;
end;
local sStage = GAMESTATE:GetCurrentStage();
local tRemap = {
	Stage_1st		= 1,
	Stage_2nd		= 2,
	Stage_3rd		= 3,
	Stage_4th		= 4,
	Stage_5th		= 5,
	Stage_6th		= 6,
};

if tRemap[sStage] == PREFSMAN:GetPreference("SongsPerPlay") then
	sStage = "Stage_Final";
else
	sStage = sStage;
end;

local t = Def.ActorFrame {};
--Player Number driven stage doors--
t[#t+1] =Def.ActorFrame{
		LoadActor("../DoorLeftP2.png")..{
		InitCommand=cmd(x,SCREEN_LEFT-100;y,SCREEN_CENTER_Y);
		OnCommand=function(self)
			if GAMESTATE:IsHumanPlayer(PLAYER_2) then
				self:diffusealpha(1);
				self:queuecommand("DoorClose");
			else
				self:diffusealpha(0);
			end;
		end;
		DoorCloseCommand=cmd(linear,0.25;x,SCREEN_CENTER_X-3;sleep,1.8;linear,0.35;x,SCREEN_LEFT-400);
	};

};
t[#t+1] =Def.ActorFrame{
		LoadActor("../DoorRightP1.png")..{
		InitCommand=cmd(x,SCREEN_RIGHT+100;y,SCREEN_CENTER_Y);
		OnCommand=function(self)
			if GAMESTATE:IsHumanPlayer(PLAYER_1) then
				self:diffusealpha(1);
				self:queuecommand("DoorClose");
			else
				self:diffusealpha(0);
			end;
		end;
		DoorCloseCommand=cmd(linear,0.25;x,SCREEN_CENTER_X+3;sleep,1.8;linear,0.45;x,SCREEN_RIGHT+400);
	};

};
--IfP1--
t[#t+1] =Def.ActorFrame{
		LoadActor("../DoorLeftP1.png")..{
		InitCommand=cmd(x,SCREEN_LEFT-100;y,SCREEN_CENTER_Y);
		OnCommand=function(self)
			if GAMESTATE:IsHumanPlayer(PLAYER_1) then
				self:diffusealpha(1);
				self:queuecommand("DoorClose");
			else
				self:diffusealpha(0);
			end;
		end;
		DoorCloseCommand=cmd(linear,0.25;x,SCREEN_CENTER_X-3;sleep,1.8;linear,0.45;x,SCREEN_LEFT-400);
	};

};
--IfP2--
t[#t+1] =Def.ActorFrame{
		LoadActor("../DoorRightP2.png")..{
		InitCommand=cmd(x,SCREEN_RIGHT+100;y,SCREEN_CENTER_Y);
		OnCommand=function(self)
			if GAMESTATE:IsHumanPlayer(PLAYER_2) then
				self:diffusealpha(1);
				self:queuecommand("DoorClose");
			else
				self:diffusealpha(0);
			end;
		end;
		DoorCloseCommand=cmd(linear,0.25;x,SCREEN_CENTER_X+3;sleep,1.8;linear,0.35;x,SCREEN_RIGHT+400);
	};

};
t[#t+1] = Def.Quad{
	OnCommand=cmd(diffuse,color("#000000");Center;setsize,326,326;diffusealpha,0;zoom,4;sleep,1.9;linear,0.2;diffusealpha,1;zoom,1);
	};
--song jacket--
t[#t+1] = Def.ActorFrame {
	OnCommand=cmd(playcommand,'Set';Center;diffusealpha,0;zoom,4;sleep,1.9;linear,0.2;diffusealpha,1;zoom,1;sleep,3;diffusealpha,1);
	Def.Sprite {
		SetCommand=function(self)
		local song = GAMESTATE:GetCurrentSong();
			if song:HasJacket() then
				self:LoadBackground(song:GetJacketPath());
				self:setsize(320,320);
			elseif song:HasBackground() then
				self:LoadFromSongBackground(GAMESTATE:GetCurrentSong());
				self:setsize(320,320);
			else
				self:Load(THEME:GetPathG("","Common fallback jacket"));
				self:setsize(320,320);
			end;
		end;
	};
};
--Stage--
t[#t+1] = Def.ActorFrame {
	InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y);
	OnCommand=cmd();

	LoadActor( THEME:GetPathG("ScreenStageInformation", "Stage " .. ToEnumShortString(sStage) ) ) .. {
		OnCommand=cmd(diffusealpha,0;sleep,2.8;diffusealpha,0;zoom,3;rotationz,-180;linear,0.25;zoom,1;rotationz,-5;diffusealpha,1);
	};
	LoadActor( THEME:GetPathG("ScreenStageInformation", "Stage " .. ToEnumShortString(sStage) ) ) .. {
		OnCommand=cmd(rotationz,-5;blend,"BlendMode_Add";diffusealpha,0;sleep,3;diffusealpha,1;decelerate,0.5;diffusealpha,0);
	};
	LoadActor( THEME:GetPathS("ScreenStageInformation", "Sound " .. ToEnumShortString(sStage) ) ) .. {
		OnCommand=cmd(play;sleep,6);
	};
	LoadActor(THEME:GetPathS( "", "_Door" ) ) .. {
		OnCommand=cmd(play);
	};
	
};



return t